import { useContext, useState } from "react";
import { Progress } from "reactstrap";
import CartContext from "@/context/cartContext";
import SettingContext from "@/context/settingContext";
import { Href } from "@/utils/constants";
import { useTranslation } from "react-i18next";
import { RiShoppingCartLine, RiTruckLine } from "react-icons/ri";
import CartVariationModal from "./CartVariationModal";
import SelectedCart from "./SelectedCart";

const HeaderCartBottom = ({
  modal,
  setModal,
  shippingFreeAmt,
  shippingCal,
}) => {
  const { convertCurrency } = useContext(SettingContext);
  const [selectedVariation, setSelectedVariation] = useState("");
  const { t } = useTranslation("common");
  const { cartProducts, getTotal, clearCart } = useContext(CartContext);

  return (
    <>
      {cartProducts?.length > 0 && (
        <>
          <div className="pere-text-box success-box">
            {shippingFreeAmt > getTotal(cartProducts) ? (
              <p>
                {t("Spend")}{" "}
                <span className="shipping">
                  {convertCurrency(shippingFreeAmt - getTotal(cartProducts))}
                </span>{" "}
                {t("more_and_enjoy")}{" "}
                <span className="shipping">{t("free_shipping")}!</span>
              </p>
            ) : (
              <p>
                <span className="shipping">{t("congratulations")}!</span>{" "}
                {t("enjoy_free_shipping_on_us")}!
              </p>
            )}
            <Progress multi>
              {shippingCal <= 30 ? (
                <Progress striped animated color="danger" value={shippingCal}>
                  <div className="progress-icon">
                    <RiTruckLine />
                  </div>
                </Progress>
              ) : shippingCal >= 31 && shippingCal <= 80 ? (
                <Progress striped animated color="warning" value={shippingCal}>
                  <div className="progress-icon">
                    <RiTruckLine />
                  </div>
                </Progress>
              ) : (
                <Progress striped animated value={shippingCal}>
                  <div className="progress-icon">
                    <RiTruckLine />
                  </div>
                </Progress>
              )}
            </Progress>
          </div>
          <div className="sidebar-title">
            <a href={Href} onClick={clearCart}>
              {t("clear_cart")}
            </a>
          </div>
          <SelectedCart
            setSelectedVariation={setSelectedVariation}
            setModal={setModal}
            modal={modal}
          />
        </>
      )}
      <CartVariationModal
        modal={modal}
        setModal={setModal}
        selectedVariation={selectedVariation}
      />
      {!cartProducts?.length && (
        <div className="cart_media empty-cart">
          <ul className="empty-cart-box">
            <div>
              <div className="icon">
                <RiShoppingCartLine />
                {/* <i className="ri-shopping-cart-line" /> */}
              </div>
              <h5>{t("no_cart_item_desc")}</h5>
            </div>
          </ul>
        </div>
      )}
    </>
  );
};

export default HeaderCartBottom;
