import React, { useEffect, useState } from "react";
import CurrencyContext from ".";
import { CurrencyAPI } from "@/utils/axiosUtils/API";
import { useQuery } from "@tanstack/react-query";
import request from "@/utils/axiosUtils";

const CurrencyProvider = (props) => {
  const [currencyState, setCurrencyState] = useState([]);
  const { data, isLoading, refetch } = useQuery(
    { queryKey: [CurrencyAPI],
      queryFn: () => request({ url: CurrencyAPI }),
        enabled: true,
        refetchOnWindowFocus: false,
        select: (res) => res?.data?.data,
    }
  );
  useEffect(() => {
    if (data) {
      setCurrencyState(data);
    }
  }, [isLoading]);

  return (
    <CurrencyContext.Provider value={{ ...props, currencyState }}>
      {props.children}
    </CurrencyContext.Provider>
  );
};

export default CurrencyProvider;
