import NoDataFound from "@/components/widgets/NoDataFound";
import BrandIdsContext from "@/context/brandIdsContext";
import { BrandSlider } from "@/data/sliderSetting";
import Link from "next/link";
import React, { useContext, useEffect } from "react";
import Slider from "react-slick";
import { Container } from "reactstrap";

const HomeBrand = ({ bgLight, brandIds, sliderOptions }) => {
  const { setGetBrandIds, filteredBrand } = useContext(BrandIdsContext);
  const brandMainSettings = sliderOptions && sliderOptions(brandIds?.length);
  const brandSliderOption = brandMainSettings ? brandMainSettings : BrandSlider(brandIds?.length);

  useEffect(() => {
    if (brandIds?.length > 0) {
      const ids = Array.from(new Set(brandIds))?.join(",");
      setGetBrandIds({ ids });
    } else {
      console.log("No brandIds passed to component.");
    }
  }, [brandIds]);

  return (
    <>
      <Container>
        {filteredBrand?.length ? (
          <div className={`row ${bgLight ? "bg-light" : ""}`}>
            <div className="brand-slider-box no-arrow">
              <Slider {...brandSliderOption}>
                {filteredBrand?.map((item, index) => (
                  <div key={index}>
                    <Link
                      className="logo-block"
                      key={index}
                      href={`/brand/${item?.slug}`}
                    >
                      {item.brand_image?.original_url ? (
                        <img
                          src={item.brand_image?.original_url}
                          alt=""
                          className="img-fluid"
                        />
                      ) : (
                        <h4>{item?.name}</h4>
                      )}
                    </Link>
                  </div>
                ))}
              </Slider>
            </div>
          </div>
        ) : (
          <NoDataFound customClass="no-data-added" title="no_brand" />
        )}
      </Container>
    </>
  );
};

export default HomeBrand;
