"use client";
import ImageLink from "@/components/widgets/imageLink";
import TitleBox from "@/components/widgets/title";
import WrapperComponent from "@/components/widgets/WrapperComponent";
import BlogIdsContext from "@/context/blogIdsContext";
import BrandIdsContext from "@/context/brandIdsContext";
import ProductIdsContext from "@/context/productIdsContext";
import {
  brandSlider4,
  categorySlider5,
  horizontalProductSlider,
  horizontalProductSlider5,
} from "@/data/sliderSetting";
import Btn from "@/elements/buttons/Btn";
import Loader from "@/layout/loader";
import { Href, storageURL } from "@/utils/constants";
import useCustomDataQuery from "@/utils/hooks/UseCustomDataQuery";
import { useSkeletonLoader2 } from "@/utils/hooks/UseSkeleton2";
import React, { useContext, useEffect, useState } from "react";
import { Col, Container, Row } from "reactstrap";
import HomeBrand from "../widgets/HomeBrand";
import HomeCategorySidebar from "../widgets/HomeCategorySidebar";
import HomeProduct from "../widgets/HomeProduct";
import HomeSlider from "../widgets/HomeSlider";
import HomeSocialMedia from "../widgets/HomeSocialMedia";

const Furniture2 = ({ slug }) => {
  const [banners, setBanners] = useState([]);
  const { setGetProductIds, isRefetching: productLoad } =
    useContext(ProductIdsContext);
  const { setGetBlogIds, isLoading: blogLoading } = useContext(BlogIdsContext);
  const { setGetBrandIds, isLoading: brandLoading } =
    useContext(BrandIdsContext);
  const videoType = ["mp4", "webm", "ogg"];
  const { data, isLoading, refetch } = useCustomDataQuery({
    params: "furniture_two",
  });

  useEffect(() => {
    if (data?.products_ids?.length > 0) {
      setGetProductIds({
        ids: Array.from(new Set(data?.products_ids))?.join(","),
      });
    }
    if (data?.brands?.brand_ids?.length > 0) {
      setGetBrandIds({
        ids: Array.from(new Set(data?.brands?.brand_ids))?.join(","),
      });
    }
    // if (data?.featured_blogs?.blog_ids?.length > 0) {
    //   setGetBlogIds({ ids: Array.from(new Set(data?.featured_blogs?.blog_ids))?.join(",") });
    // }
  }, [data]);
  useEffect(() => {
    const bannersArray = [];
    if (data?.offer_banner?.banner_1?.status) {
      bannersArray.push(data?.offer_banner?.banner_1);
    }
    if (data?.offer_banner?.banner_2?.status) {
      bannersArray.push(data?.offer_banner?.banner_2);
    }
    if (data?.offer_banner?.banner_3?.status) {
      bannersArray.push(data?.offer_banner?.banner_3);
    }
    setBanners(bannersArray);

    if (data?.products_ids?.length > 0) {
      setGetProductIds({
        ids: Array.from(new Set(data?.products_ids))?.join(","),
      });
    }
    if (data?.brands?.brand_ids?.length > 0) {
      setGetBrandIds({
        ids: Array.from(new Set(data?.brands?.brand_ids))?.join(","),
      });
    }
    // if (data?.featured_blogs?.blog_ids?.length > 0) {
    //   setGetBlogIds({ ids: Array.from(new Set(data?.featured_blogs?.blog_ids))?.join(",") });
    // }
  }, [data]);

  useEffect(() => {
    refetch();
  }, [isLoading]);

  useEffect(() => {
    document.body.classList.add("home", "header-style-light");
    return () => {
      document.body.classList.remove("home", "header-style-light");
    };
  }, []);

  useSkeletonLoader2([productLoad, blogLoading, brandLoading]);
  if (isLoading && document.body) return <Loader />;

  return (
    <>
      {/* Home Banners */}
      <WrapperComponent classes={{ sectionClass: "p-0 overflow-hidden" }}>
        <div className="slide-1 home-slider">
          <HomeSlider
            bannerData={data?.home_banner}
            height={650}
            width={1920}
          />
        </div>
      </WrapperComponent>

      {/* Offer Banners  */}
      <WrapperComponent
        classes={{
          sectionClass:
            "banner-padding banner-section absolute-banner pb-0 ratio2_1",
          fluidClass: "container overflow-hidden absolute-bg",
        }}
        customCol={true}
      >
        {banners.map(
          (banner, i) =>
            banner?.status && (
              <div
                key={i}
                className={`${banners.length === 3
                    ? "col-md-4 col-sm-6"
                    : banners.length === 2
                      ? "col-md-6"
                      : "col-12"
                  }`}
              >
                <div className="position-relative">
                  <ImageLink
                    imgUrl={banner}
                    bgImage={true}
                    height={261}
                    width={581}
                  />
                  <div className="banner-skeleton">
                    <div className="skeleton-content">
                      <p className="card-text placeholder-glow row g-lg-3 g-0">
                        <span className="col-lg-7 col-9">
                          <span className="placeholder"></span>
                        </span>
                        <span className="col-lg-9 col-12">
                          <span className="placeholder"></span>
                        </span>
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            )
        )}
      </WrapperComponent>

      {/* Categories */}
      <Container className="no-arrow">
        <section className="category-style-1 section-t-space">
          <HomeCategorySidebar
            style="simple"
            sliderOptions={categorySlider5}
            slider={true}
            categoryIds={data?.categories_icon_list?.category_ids || []}
          />
        </section>
      </Container>

      {/* Products List 1 */}
      {data?.products_list_1?.status && data?.products_list_1?.product_ids && (
        <>
          <TitleBox title={data?.products_list_1} type="basic" />
          <WrapperComponent
            classes={{
              sectionClass: "section-b-space pt-0 featured-products",
              fluidClass: "container",
            }}
          >
            <HomeProduct
              productIds={data?.products_list_1?.product_ids || []}
              style="vertical"
              slider={true}
              sliderOptions={horizontalProductSlider5}
            />
          </WrapperComponent>
        </>
      )}

      {/* Grid Banners */}
      {data?.grid_banner?.status && (
        <div className="category-bg ratio3_2">
          <Container fluid className="p-0">
            <Row className="order-section">
              {data?.grid_banner?.banners.map((banner, index) => {
                if (banner?.image_url) {
                  if (
                    videoType.includes(
                      banner?.image_url.substring(
                        banner?.image_url.lastIndexOf(".") + 1
                      )
                    )
                  ) {
                    return (
                      <Col sm="8" className=" p-0" key={index}>
                        <a href={Href} className="image-block">
                          <div id="block" className="video-sec">
                            <div>
                              <video autoPlay loop>
                                <source
                                  src={storageURL + banner?.image_url}
                                  type="video/mp4"
                                />
                              </video>
                            </div>
                          </div>
                        </a>
                      </Col>
                    );
                  } else {
                    return (
                      <Col sm="4" className=" p-0" key={index}>
                        <ImageLink imgUrl={banner} height={200} width={200} />
                      </Col>
                    );
                  }
                } else {
                  return (
                    <Col sm="4" className=" p-0" key={index}>
                      <div className="contain-block even">
                        <div>
                          <h6>{banner?.tag}</h6>
                          <a href={Href}>
                            <h2>{banner?.title}</h2>
                          </a>
                          <Btn href={Href} className=" btn-solid category-btn">
                            {banner?.button_text}
                          </Btn>
                          <a href={Href}>
                            <h6>
                              <span>shop now</span>
                            </h6>
                          </a>
                        </div>
                      </div>
                    </Col>
                  );
                }
              })}
            </Row>
          </Container>
        </div>
      )}

      {/* Products List 2 */}
      {data?.product_list_2?.status && (
        <WrapperComponent
          classes={{ sectionClass: "featured-products", fluidClass: "container", row: "g-4" }}
          customCol={true}
        >
          <div
            className={
              data?.product_list_2?.right_panel?.status
                ? "col-xl-9 col-lg-8"
                : "col-xl-12 col-lg-8"
            }
          >
            <div className="theme-tab">
              <div className="tab-content-cls">
                <HomeProduct
                  productIds={
                    data?.product_list_2?.products?.product_item?.product_ids ||
                    []
                  }
                  slider={true}
                  sliderOptions={horizontalProductSlider}
                  style="vertical"
                />
              </div>
              {(data?.product_list_2?.products?.product_banner?.banner_1
                ?.status ||
                data?.product_list_2?.products?.product_banner?.banner_2
                  ?.status) && (
                  <div className="banner-tools border-0 product_banner banner-section">
                    <div className="ratio2_1">
                      <Container className=" p-0">
                        <Row className="g-4">
                          {data?.product_list_2?.products?.product_banner
                            ?.banner_1?.status && (
                              <div
                                className={
                                  data?.product_list_2?.products?.product_banner
                                    ?.banner_2?.status
                                    ? "col-md-6"
                                    : "col-12"
                                }
                              >
                                <ImageLink
                                  imgUrl={
                                    data?.product_list_2?.products?.product_banner
                                      ?.banner_1
                                  }
                                  bgImg={true}
                                />
                              </div>
                            )}
                          {data?.product_list_2?.products?.product_banner
                            ?.banner_2?.status && (
                              <div
                                className={
                                  data?.product_list_2?.products?.product_banner
                                    ?.banner_1?.status
                                    ? "col-md-6"
                                    : "col-12"
                                }
                              >
                                <ImageLink
                                  imgUrl={
                                    data?.product_list_2?.products?.product_banner
                                      ?.banner_2
                                  }
                                  bgImg={true}
                                />
                              </div>
                            )}
                        </Row>
                      </Container>
                    </div>
                  </div>
                )}
            </div>
          </div>
          {data?.product_list_2?.right_panel?.status && (
            <Col xl="3" lg="4" md="12" className="mb-0 images">
              <div className="theme-card">
                <h5 className="title-border">
                  {data?.product_list_2?.right_panel?.title}
                </h5>
                <div className="offer-slider ">
                  <HomeProduct
                    productIds={
                      data?.product_list_2?.right_panel?.product_ids || []
                    }
                    style="horizontal"
                  />
                </div>
              </div>
            </Col>
          )}
        </WrapperComponent>
      )}

      {/* Brands */}
      {data?.brand?.status && (
        <WrapperComponent classes={{ sectionClass: "tools-brand" }}>
          <HomeBrand
            sliderOptions={brandSlider4}
            brandIds={data?.brand?.brand_ids || []}
            bgLight={true}
          />
        </WrapperComponent>
      )}

      {/* Social Media */}
      {data?.social_media?.banners?.length && data?.social_media?.status && (
        <section className="instagram ratio_square section-t-space">
          <HomeSocialMedia media={data?.social_media || []} type="borderless" />
        </section>
      )}
    </>
  );
};

export default Furniture2;
