import SimpleInputField from "@/components/widgets/inputFields/SimpleInputField";
import { AllCountryCode } from "@/data/CountryCode";
import SearchableSelectInput from "@/utils/commonComponents/inputFields/SearchableSelectInput";
import { useTranslation } from "react-i18next";
import { Col, Row } from "reactstrap";

const ShippingAddressForm = ({ values, data }) => {
  const { t } = useTranslation("common");
  return (
    <div className="checkbox-main-box">
      <div className="checkout-title1">
        <h2>{t("shipping_details")}</h2>
      </div>
      <Row className="checkout-form g-md-4 g-sm-3 g-2">
        <SimpleInputField
          nameList={[
            {
              name: "shipping_address.title",
              placeholder: t("enter_title"),
              toplabel: "Title",
              colprops: { xs: 12 },
              require: "true",
            },
            {
              name: "shipping_address.street",
              placeholder: t("enter_address"),
              toplabel: "Address",
              colprops: { xs: 12 },
              require: "true",
            },
          ]}
        />
        <SearchableSelectInput
          nameList={[
            {
              name: "shipping_address.country_id",
              require: "true",
              title: "country",
              toplabel: "Country",
              colprops: { xxl: 6, lg: 12, sm: 6 },
              inputprops: {
                name: "shipping_address.country_id",
                id: "shipping_address.country_id",
                options: data,
                defaultOption: "Select state",
              },
            },

            {
              name: "shipping_address.state_id",
              require: "true",
              title: "State",
              toplabel: "State",
              colprops: { xxl: 6, lg: 12, sm: 6 },
              inputprops: {
                name: "shipping_address.state_id",
                id: "shipping_address.state_id",
                options: values?.shipping_address?.country_id
                  ? data?.filter(
                      (country) =>
                        Number(country.id) ===
                        Number(values?.shipping_address?.country_id)
                    )?.[0]?.["state"]
                  : [],
                defaultOption: "Select state",
              },
              disabled: values?.["shipping_address.country_id"] ? false : true,
            },
          ]}
        />
        <SimpleInputField
          nameList={[
            {
              name: "shipping_address.city",
              placeholder: t("enter_city"),
              toplabel: "City",
              colprops: { md: 6 },
              require: "true",
            },
            {
              name: "shipping_address.pincode",
              placeholder: t("enter_pincode"),
              toplabel: "Pincode",
              colprops: { md: 6 },
              require: "true",
            },
          ]}
        />
        <Col xs={12} className="phone-field">
          <div className="form-box position-relative">
            <div className="country-input">
              <SimpleInputField
                nameList={[
                  {
                    name: "shipping_address.phone",
                    type: "number",
                    placeholder: t("enter_phone"),
                    require: "true",
                    toplabel: "Phone",
                    colprops: { xs: 12 },
                    colclass: "country-input-box",
                  },
                ]}
              />
              <SearchableSelectInput
                nameList={[
                  {
                    name: "shipping_address.country_code",
                    notitle: "true",
                    inputprops: {
                      name: "shipping_address.country_code",
                      id: "shipping_address.country_code",
                      options: AllCountryCode,
                    },
                  },
                ]}
              />
            </div>
          </div>
        </Col>
      </Row>
    </div>
  );
};

export default ShippingAddressForm;
