"use client";
import WrapperComponent from "@/components/widgets/WrapperComponent";
import Breadcrumb from "@/utils/commonComponents/breadcrumb";
import { Col, TabPane } from "reactstrap";
import AccountSidebar from "../common/AccountSidebar";
import ResponsiveMenuOpen from "../common/ResponsiveMenuOpen";
import RefundTable from "./RefundTable";

const AccountRefund = () => {
  return (
    <>
      <Breadcrumb title={"refund"} subNavigation={[{ name: "Refund" }]} />
      <WrapperComponent
        classes={{
          sectionClass:
            "dashboard-section section-b-space user-dashboard-section",
          fluidClass: "container",
        }}
        customCol={true}
      >
        <AccountSidebar tabActive={"refund"} />
        <Col lg={9}>
          <div className="faq-content">
            <div className="tab-content">
              <ResponsiveMenuOpen />
              <TabPane className="show fade active">
                <RefundTable />
              </TabPane>
            </div>
          </div>
        </Col>
      </WrapperComponent>
    </>
  );
};

export default AccountRefund;
