import SearchableSelectInput from "@/components/widgets/inputFields/SearchableSelectInput";
import SimpleInputField from "@/components/widgets/inputFields/SimpleInputField";
import { AllCountryCode } from "@/data/CountryCode";
import Btn from "@/elements/buttons/Btn";
import { Form } from "formik";
import { useTranslation } from "react-i18next";
import { Col, ModalFooter, Row } from "reactstrap";

const SelectForm = ({
  values,
  isLoading,
  data,
  setModal,
  isFooterDisplay = true,
}) => {
  const { t } = useTranslation("common");
  return (
    <Form>
      <Row>
        <SimpleInputField
          nameList={[
            {
              name: "title",
              placeholder: t("enter_title"),
              toplabel: "Title",
              colprops: { xs: 12 },
              require: "true",
            },
            {
              name: "street",
              placeholder: t("enter_address"),
              toplabel: "Address",
              colprops: { xs: 12 },
              require: "true",
            },
          ]}
        />
        <Col xs="12" className="phone-field">
          <div className="country-input position-relative">
            <SimpleInputField
              nameList={[
                {
                  name: "phone",
                  type: "number",
                  placeholder: t("enter_phone"),
                  require: "true",
                  toplabel: "Phone",
                  colclass: "country-input-box",
                },
              ]}
            />
            <SearchableSelectInput
              nameList={[
                {
                  name: "country_code",
                  notitle: "true",
                  inputprops: {
                    name: "country_code",
                    id: "country_code",
                    options: AllCountryCode,
                  },
                },
              ]}
            />
          </div>
        </Col>
        <SearchableSelectInput
          nameList={[
            {
              name: "country_id",
              require: "true",
              title: "Country",
              toplabel: "Country",
              colprops: { xxl: 6, lg: 12, sm: 6 },
              inputprops: {
                name: "country_id",
                id: "country_id",
                options: data,
                defaultOption: "Select state",
              },
            },
            {
              name: "state_id",
              require: "true",
              title: "State",
              toplabel: "State",
              colprops: { xxl: 6, lg: 12, sm: 6 },
              inputprops: {
                name: "state_id",
                id: "state_id",
                options: values?.["country_id"]
                  ? data?.filter(
                      (country) =>
                        Number(country.id) === Number(values?.["country_id"])
                    )?.[0]?.["state"]
                  : [],
                defaultOption: "Select state",
              },
              disabled: values?.["country_id"] ? false : true,
            },
          ]}
        />
        <SimpleInputField
          nameList={[
            {
              name: "city",
              placeholder: t("enter_city"),
              toplabel: "City",
              colprops: { xxl: 6, lg: 12, sm: 6 },
              require: "true",
            },
            {
              name: "pincode",
              placeholder: t("enter_pincode"),
              toplabel: "Pincode",
              colprops: { xxl: 6, lg: 12, sm: 6 },
              require: "true",
            },
          ]}
        />

        <Col xs="12">
          {isFooterDisplay && (
            <ModalFooter className="ms-auto justify-content-end save-back-button mt-0">
              <Btn
                className="btn-md btn-outline fw-bold"
                color="transparent"
                onClick={() => setModal(false)}
              >
                {t("cancel")}
              </Btn>
              <Btn
                className="btn-solid"
                type="submit"
                loading={Number(isLoading)}
              >
                {t("submit")}
              </Btn>
            </ModalFooter>
          )}
        </Col>
      </Row>
    </Form>
  );
};

export default SelectForm;
