<?php

namespace App\Models;

use Spatie\MediaLibrary\HasMedia;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Spatie\MediaLibrary\InteractsWithMedia;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ThemeOption extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia, HasTranslations;

    public $translatable = [
        'options'
    ];

    protected $casts = [
        'options' => 'json',
    ];

    /**
     * The Options that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'options',
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function getOptionsAttribute($value)
    {
        $options = json_decode($value, true);
        if (is_null($options) || !is_array($options)) {
            return null;
        }

        $requestedLocale = request()->header('Accept-Lang', app()->getLocale());
        $fallbackLocale = config('app.fallback_locale');
        if (isset($options[$requestedLocale])) {
            $selectedOptions = $options[$requestedLocale];
        }
        elseif (isset($options[$fallbackLocale])) {
            $selectedOptions = $options[$fallbackLocale];
        }
        else {
            return null;
        }

        if (is_null($selectedOptions)) {
            return null;
        }

        if (isset($selectedOptions['logo'])) {
            $selectedOptions['logo']['header_logo'] = Attachment::find($selectedOptions['logo']['header_logo_id']);
            $selectedOptions['logo']['footer_logo'] = Attachment::find($selectedOptions['logo']['footer_logo_id']);
            $selectedOptions['logo']['favicon_icon'] = Attachment::find($selectedOptions['logo']['favicon_icon_id']);
        }

        if (isset($selectedOptions['seo'])) {
            $selectedOptions['seo']['og_image'] = Attachment::find($selectedOptions['seo']['og_image_id']);
        }

        return $selectedOptions;
    }

    public function toArray()
    {
        return [
            'id' => $this->id,
            'options' => $this->getOptionsAttribute($this->getRawOriginal('options')),
        ];
    }


    /**
     * @return BelongsTo
     */
    public function front_site_logo(): BelongsTo
    {
        return $this->belongsTo(Attachment::class, 'front_site_logo_id');
    }

    /**
     * @return BelongsTo
     */
    public function front_site_favicon(): BelongsTo
    {
        return $this->belongsTo(Attachment::class, 'front_site_favicon_id');
    }
}
