<?php

namespace App\Console\Commands;

use ZipArchive;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class ResetLang extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'lang:reset';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $langPath = resource_path('lang'); // Path to lang folder
        $resetLangZip = public_path('lang.zip'); // Path to lang.zip file

        // Check if lang.zip exists
        if (!File::exists($resetLangZip)) {
            $this->error('lang.zip file not found in the public directory.');
            return;
        }

        $zip = new ZipArchive;
        if ($zip->open($resetLangZip) === true) {
            $foldersToReplace = [];

            // Get a list of top-level folders in the ZIP (languages)
            for ($i = 0; $i < $zip->numFiles; $i++) {
                $fileName = $zip->getNameIndex($i);
                $folder = explode('/', $fileName)[0]; // Extract top-level folder name

                if ($folder && !in_array($folder, $foldersToReplace)) {
                    $foldersToReplace[] = $folder;
                }
            }

            foreach ($foldersToReplace as $folder) {
                $folderPath = $langPath . '/' . $folder;

                
                // Delete the existing language folder if it exists
                if (File::exists($folderPath)) {
                    File::deleteDirectory($folderPath);
                }
                
                // Extract only the specific folder from the ZIP
                for ($i = 0; $i < $zip->numFiles; $i++) {
                    $fileName = $zip->getNameIndex($i);
                    
                    if (strpos($fileName, "$folder/") === 0) {
                        $zip->extractTo($langPath, [$fileName]);
                    }
                }
            }
            $zip->close();
        } else {
            $this->error('Failed to open lang.zip.');
        }
    }
}
