import { useReducer } from "react";
import { useCookies } from "react-cookie";
import React, { useEffect, useState } from "react";
import { settingReducer } from "../../utils/allReducers";
import { useQuery } from "@tanstack/react-query";
import request from "../../utils/axiosUtils";
import { BadgeApi } from "../../utils/axiosUtils/API";
import BadgeContext from ".";
import { useRouter } from "next/navigation";

const BadgeProvider = (props) => {
  const [cookies] = useCookies(["uat_multikart"]);
  const [state, dispatch] = useReducer(settingReducer, {
    badges: [],
    notification: "",
  });
  const [notification, setNotification] = useState("");
  const router = useRouter();
  const { data, isLoading, refetch } = useQuery(
    { queryKey: [BadgeApi],
      queryFn: () => request({ url: BadgeApi }, router),
        enabled: false,
        select: (res) => res?.data,
    }
  );
  useEffect(() => {
    cookies.uat_multikart && refetch();
  }, [cookies.uat_multikart]);

  useEffect(() => {
    if (data) {
      dispatch({
        type: "ALLBADGE",
        allBadges: [
          {
            path: "/product",
            value: data?.product?.total_in_approved_products,
            subKey: ["product", "total_in_approved_products"],
          },
          {
            path: "/store",
            value: data?.store?.total_in_approved_stores,
            subKey: ["store", "total_in_approved_stores"],
          },
          {
            path: "/refund",
            value: data?.refund?.total_pending_refunds,
            subKey: ["refund", "total_pending_refunds"],
          },
          {
            path: "/withdraw_request",
            value: data?.withdraw_request?.total_pending_withdraw_requests,
            subKey: ["withdraw_request", "total_pending_withdraw_requests"],
          },
        ],
      });
    }
  }, [isLoading]);
  return (
    <BadgeContext.Provider
      value={{ state, dispatch, notification, setNotification, ...props }}
    >
      {props.children}
    </BadgeContext.Provider>
  );
};
export default BadgeProvider;
