import { Fragment } from "react";
import Image from "next/image";
import Btn from "@/elements/buttons/Btn";
import { placeHolderImage } from "../../../data/CommonPath";

const ImageOtherAttributes = ({
  setVariant,
  productState,
  elem,
  soldOutAttributesIds,
}) => {
  return (
    <ul className={`select-package ${elem?.style ?? ""}`}>
      {elem?.attribute_values?.map((item, index) => (
        <Fragment key={index}>
          {productState?.attributeValues?.includes(item?.id) && (
            <li
              className={`${
                productState?.variantIds?.includes(item?.id) ? "active" : ""
              } ${soldOutAttributesIds?.includes(item.id) ? "disabled" : ""}`}
              title={item?.value}
            >
              {elem?.style == "image" ? (
                <Image
                  src={
                    item?.variation_image
                      ? item?.variation_image?.original_url
                      : placeHolderImage
                  }
                  onClick={() =>
                    setVariant(productState?.product?.variations, item)
                  }
                  height={65}
                  width={65}
                  alt="Product"
                />
              ) : (
                <Btn
                  onClick={() =>
                    setVariant(productState?.product?.variations, item)
                  }
                >
                  {item?.value}
                </Btn>
              )}
            </li>
          )}
        </Fragment>
      ))}
    </ul>
  );
};

export default ImageOtherAttributes;
