import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import Btn from "@/elements/buttons/Btn";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import { useState } from "react";
import { useTranslation } from "react-i18next";
import { RiArrowDownLine, RiCloseLine } from "react-icons/ri";
import { Col, Row } from "reactstrap";
import CommonRedirect from "../../CommonRedirect";
import { mediaConfig } from "@/data/MediaConfig";

const BannerTab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  const { t } = useTranslation("common");
  const [active, setActive] = useState();
  const removeBanners = (index) => {
    if (values["content"]["banner"]["banners"].length > 1) {
      let filterValue = values["content"]["banner"]["banners"].filter(
        (item, i) => i !== index
      );
      setFieldValue("[content][banner][banners]", filterValue);
      filterValue?.forEach((elem, i) => {
        elem?.image_url &&
          setFieldValue(`bannerImage${i}`, { original_url: elem?.image_url });
        elem?.redirect_link?.link_type &&
          setFieldValue(
            `bannerRedirectLinkType${i}`,
            elem?.redirect_link?.link_type
          );
        elem?.redirect_link?.link &&
          setFieldValue(`bannerRedirectLink${i}`, elem?.redirect_link?.link);
      });
    }
  };
  return (
    <>
      {
        <Btn
          className="btn-theme my-4"
          onClick={() =>
            setFieldValue("[content][banner][banners]", [
              ...values["content"]?.["banner"]["banners"],
              { title: "", description: "" },
            ])
          }
          title="add_banners"
        />
      }
      {values["content"]?.["banner"]?.["banners"]?.map((elem, index) => {
        return (
          <Row className="align-items-center" key={index}>
            <Col xs="11">
              <div className="shipping-accordion-custom">
                <div
                  className="p-3 rule-dropdown d-flex justify-content-between"
                  onClick={() => setActive((prev) => prev !== index && index)}
                >
                  {t("banner") + " " + (index + 1)}
                  <RiArrowDownLine />
                </div>
                {active == index && (
                  <div className="rule-edit-form">
                    <FileUploadField
                      paramsProps={{ mime_type: mediaConfig.image.join(",") }}
                      name={`bannerImage${index}`}
                      title="image"
                      id={`bannerImage${index}`}
                      type="file"
                      values={values}
                      setFieldValue={setFieldValue}
                      showImage={values[`bannerImage${index}`]}
                      helpertext={getHelperText("376x231px")}
                    />
                    <CommonRedirect
                      values={values}
                      setFieldValue={setFieldValue}
                      productData={productData}
                      categoryData={categoryData}
                      nameList={{
                        selectNameKey: `bannerRedirectLinkType${index}`,
                        multipleNameKey: `bannerRedirectLink${index}`,
                      }}
                      setSearch={setSearch}
                    />
                    <CheckBoxField
                      name={`[content][banner][banners][${index}][status]`}
                      title="status"
                    />
                  </div>
                )}
              </div>
            </Col>
            <Col xs="1">
              <a
                className="h-100 w-100 cursor-pointer close-icon"
                onClick={() => removeBanners(index)}
              >
                <RiCloseLine />
              </a>
            </Col>
          </Row>
        );
      })}
    </>
  );
};

export default BannerTab;
