import { ConcatDynamicProductKeys } from "../../../../utils/customFunctions/ConcatDynamicProductKeys";

const VegetableOneSubmit = (values, mutate) => {
  values["content"]["products_ids"] = Array.from(
    new Set(ConcatDynamicProductKeys(values))
  );
if (Array.isArray(values["content"]?.["home_banner"]?.["banners"])) {
  values["content"]["home_banner"]["banners"].forEach((elem, i) => {
    if (!values["content"]["home_banner"]["banners"][i]["redirect_link"]) {
      values["content"]["home_banner"]["banners"][i]["redirect_link"] = {}; // Initialize redirect_link if undefined
    }

    if (values[`homeBannerImage${i}`]) {
      values["content"]["home_banner"]["banners"][i]["image_url"] = values[
        `homeBannerImage${i}`
      ].hasOwnProperty("asset_url")
        ? values[`homeBannerImage${i}`].asset_url
        : values[`homeBannerImage${i}`].original_url;
    } else {
      values["content"]["home_banner"]["banners"][i]["image_url"] = "";
    }

    if (values[`homeRedirectLinkType${i}`] || values[`homeRedirectLink${i}`]) {
      values["content"]["home_banner"]["banners"][i]["redirect_link"][
        "link_type"
      ] = values[`homeRedirectLinkType${i}`];
      values["content"]["home_banner"]["banners"][i]["redirect_link"]["link"] =
        values[`homeRedirectLink${i}`];
      if (values[`homeRedirectLinkType${i}`] == "product") {
        values["content"]["home_banner"]["banners"][i]["redirect_link"][
          "product_ids"
        ] = values[`homeRedirectLink${i}`];
      } else {
        values["content"]["home_banner"]["banners"][i]["redirect_link"][
          "product_ids"
        ] = "";
      }
    } else {
      values["content"]["home_banner"]["banners"][i]["redirect_link"][
        "link_type"
      ] = "";
      values["content"]["home_banner"]["banners"][i]["redirect_link"]["link"] =
        "";
    }
  });
}

  if (Array.isArray(values["content"]?.["services"]?.["banners"])) {
    values["content"]["services"]["banners"].forEach((elem, i) => {
      if (!values["content"]["services"]["banners"][i]) {
        values["content"]["services"]["banners"][i] = {}; // ✅ ensure the banner exists
      }
      if (values[`serviceBannerImage${i}`]) {
        values["content"]["services"]["banners"][i]["image_url"] = values[
          `serviceBannerImage${i}`
        ].hasOwnProperty("asset_url")
          ? values[`serviceBannerImage${i}`].asset_url
          : values[`serviceBannerImage${i}`].original_url;
      } else {
        values["content"]["services"]["banners"][i]["image_url"] = "";
      }
    });
  }

  // Redirect Link

  if (values["fullBannerRedirectLinkType"]) {
    values["content"]["full_banner"]["redirect_link"]["link_type"] =
      values["fullBannerRedirectLinkType"];
  } else {
    values["content"]["full_banner"]["redirect_link"]["link_type"] = "";
    values["content"]["full_banner"]["redirect_link"]["link"] = "";
  }
  if (values["fullBannerRedirectLink"]) {
    values["content"]["full_banner"]["redirect_link"]["link"] =
      values["fullBannerRedirectLink"];
    if (values["fullBannerRedirectLinkType"] == "product") {
      values["content"]["full_banner"]["redirect_link"]["link"] =
        values["fullBannerRedirectLink"];
    } else {
      values["content"]["full_banner"]["redirect_link"]["link"] = "";
    }
  } else {
    values["content"]["full_banner"]["redirect_link"]["link"] = "";
  }
  // ============================================================================================
  // Images
  if (!values["content"]["parallax_banner"]) {
    values["content"]["parallax_banner"] = {};
  }

  if (values["parallaxBannerImage"]) {
    values["content"]["parallax_banner"]["image_url"] = values[
      `parallaxBannerImage`
    ].hasOwnProperty("asset_url")
      ? values[`parallaxBannerImage`].asset_url
      : values[`parallaxBannerImage`].original_url;
  } else {
    values["content"]["parallax_banner"]["image_url"] = "";
  }


  // ============================================================================================
  //MultiSelect
  if (values["featuredBlogList"]) {
    values["content"]["featured_blogs"]["blog_ids"] =
      values["featuredBlogList"];
  }
  if (values["brandItems"]) {
    values["content"]["brand"]["brand_ids"] = values["brandItems"];
  }

  if (values["productList1Product"]) {
    values["content"]["products_list_1"]["product_ids"] =
      values["productList1Product"];
  }

  if (values["productList2Product"]) {
    values["content"]["products_list_2"]["product_ids"] =
      values["productList2Product"];
  }

  const updatedValues = {
    ...values,
    content: {
      ...values.content,
      products_ids: Array.from(new Set(ConcatDynamicProductKeys(values))),
    },
  };

  mutate(updatedValues);
};
export default VegetableOneSubmit;
