import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import SearchableSelectInput from "@/components/inputFields/SearchableSelectInput";
import SimpleInputField from "@/components/inputFields/SimpleInputField";
import TabTitle from "@/components/widgets/TabTitle";
import { MedicalColumnBannerProductTitle } from "@/data/TabTitleList";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import { useState } from "react";
import { useTranslation } from "react-i18next";
import { TabContent, TabPane } from "reactstrap";
import CommonRedirect from "../../CommonRedirect";
import { mediaConfig } from "@/data/MediaConfig";

const ColumnBannerProductTab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  const { t } = useTranslation("common");
  const [activeTab, setActiveTab] = useState("1");
  return (
    <div className="inside-horizontal-tabs">
      <CheckBoxField
        name={`[content][column_banner_product][status]`}
        title="status"
      />
      <TabTitle
        activeTab={activeTab}
        setActiveTab={setActiveTab}
        titleList={MedicalColumnBannerProductTitle}
      />
      <TabContent activeTab={activeTab}>
        <TabPane tabId="1">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="columnOfferBanner1Image"
            title="image"
            id="columnOfferBanner1Image"
            showImage={values["columnOfferBanner1Image"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "columnOfferBanner1LinkType",
              multipleNameKey: "columnOfferBanner1Link",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][column_banner_product][offer_banner_1][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="2">
          <SimpleInputField
            nameList={[
              {
                name: `[content][column_banner_product][product_list_1][title]`,
                placeholder: t("enter_title"),
                title: "title",
              },
            ]}
          />
          <SearchableSelectInput
            nameList={[
              {
                name: "columnProductList1Product",
                title: "products",
                inputprops: {
                  name: "columnProductList1Product",
                  id: "columnProductList1Product",
                  options: productData || [],
                  setsearch: setSearch,
                },
              },
            ]}
          />
          <CheckBoxField
            name={`[content][column_banner_product][product_list_1][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="3">
          <FileUploadField
            name="columnOfferBanner2Image"
            title="image"
            id="columnOfferBanner2Image"
            showImage={values["columnOfferBanner2Image"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "columnOfferBanner2LinkType",
              multipleNameKey: "columnOfferBanner2Link",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][column_banner_product][offer_banner_2][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="4">
          <SimpleInputField
            nameList={[
              {
                name: `[content][column_banner_product][product_list_2][title]`,
                placeholder: t("enter_title"),
                title: "title",
              },
            ]}
          />
          <SearchableSelectInput
            nameList={[
              {
                name: "columnProductList2Product",
                title: "products",
                inputprops: {
                  name: "columnProductList2Product",
                  id: "columnProductList2Product",
                  options: productData || [],
                  setsearch: setSearch,
                },
              },
            ]}
          />
          <CheckBoxField
            name={`[content][column_banner_product][product_list_2][status]`}
            title="status"
          />
        </TabPane>
      </TabContent>
    </div>
  );
};

export default ColumnBannerProductTab;
