import SimpleInputField from "@/components/inputFields/SimpleInputField";
import { useState } from "react";
import { useTranslation } from "react-i18next";
import { TabContent, TabPane } from "reactstrap";
import { MedicalColumnBannerProductTitle } from "@/data/TabTitleList";
import CheckBoxField from "@/components/inputFields/CheckBoxField";
import SearchableSelectInput from "@/components/inputFields/SearchableSelectInput";
import TabTitle from "@/components/widgets/TabTitle";
import FileUploadField from "@/components/inputFields/FileUploadField";
import CommonRedirect from "../../CommonRedirect";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import { mediaConfig } from "@/data/MediaConfig";

const ColumnBannerProductTab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  const { t } = useTranslation("common");
  const [activeTab, setActiveTab] = useState("1");
  return (
    <div className="inside-horizontal-tabs">
      <CheckBoxField
        name={`[content][column_banner_product][status]`}
        title="status"
      />
      <TabTitle
        activeTab={activeTab}
        setActiveTab={setActiveTab}
        titleList={MedicalColumnBannerProductTitle}
      />
      <TabContent activeTab={activeTab}>
        <TabPane tabId="1">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="offerBanner1Image"
            title="image"
            id="offerBanner1Image"
            showImage={values["offerBanner1Image"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "offerBanner1LinkType",
              multipleNameKey: "offerBanner1Link",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][column_banner_product][offer_banner_1][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="2">
          <SimpleInputField
            nameList={[
              {
                name: `[content][column_banner_product][product_list_1][title]`,
                placeholder: t("enter_title"),
                title: "title",
              },
            ]}
          />
          <SearchableSelectInput
            nameList={[
              {
                name: "productList1Product",
                title: "products",
                inputprops: {
                  name: "productList1Product",
                  id: "productList1Product",
                  options: productData || [],
                  setsearch: setSearch,
                },
              },
            ]}
          />
          <CheckBoxField
            name={`[content][column_banner_product][product_list_1][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="3">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="offerBanner2Image"
            title="image"
            id="offerBanner2Image"
            showImage={values["offerBanner2Image"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "offerBanner2LinkType",
              multipleNameKey: "offerBanner2Link",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][column_banner_product][offer_banner_2][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="4">
          <SimpleInputField
            nameList={[
              {
                name: `[content][column_banner_product][product_list_2][title]`,
                placeholder: t("enter_title"),
                title: "title",
              },
            ]}
          />
          <SearchableSelectInput
            nameList={[
              {
                name: "productList2Product",
                title: "products",
                inputprops: {
                  name: "productList2Product",
                  id: "productList2Product",
                  options: productData || [],
                  setsearch: setSearch,
                },
              },
            ]}
          />
          <CheckBoxField
            name={`[content][column_banner_product][product_list_2][status]`}
            title="status"
          />
        </TabPane>
      </TabContent>
    </div>
  );
};

export default ColumnBannerProductTab;
