import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import TabTitle from "@/components/widgets/TabTitle";
import { mediaConfig } from "@/data/MediaConfig";
import { MarketplaceTwoOfferBanner2Title } from "@/data/TabTitleList";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import { useState } from "react";
import { TabContent, TabPane } from "reactstrap";
import CommonRedirect from "../../CommonRedirect";

const OfferBannerTab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  const [activeTab, setActiveTab] = useState("1");
  return (
    <div className="inside-horizontal-tabs">
      <CheckBoxField
        name={`[content][offer_banner_2][status]`}
        title="status"
      />
      <TabTitle
        activeTab={activeTab}
        setActiveTab={setActiveTab}
        titleList={MarketplaceTwoOfferBanner2Title}
      />
      <TabContent activeTab={activeTab}>
        <TabPane tabId="1">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="offerBanner2Image1"
            title="image"
            id="offerBanner2Image1"
            showImage={values["offerBanner2Image1"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "offerBanner2LinkType1",
              multipleNameKey: "offerBanner2Link1",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][offer_banner_1][banner_1][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="2">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="offerBanner2Image2"
            title="image"
            id="offerBanner2Image2"
            showImage={values["offerBanner2Image2"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "offerBanner2LinkType2",
              multipleNameKey: "offerBanner2Link2",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][offer_banner_1][banner_1][status]`}
            title="status"
          />
        </TabPane>
      </TabContent>
    </div>
  );
};

export default OfferBannerTab;
