import CommonRedirect from "@/components/homePages/CommonRedirect";
import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import MultiSelectField from "@/components/inputFields/MultiSelectField";
import SearchableSelectInput from "@/components/inputFields/SearchableSelectInput";
import SimpleInputField from "@/components/inputFields/SimpleInputField";
import TabTitle from "@/components/widgets/TabTitle";
import { mediaConfig } from "@/data/MediaConfig";
import { MarketplaceCategoryProductOfferBannerTitle } from "@/data/TabTitleList";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import { useState } from "react";
import { useTranslation } from "react-i18next";
import { RiArrowDownLine } from "react-icons/ri";
import { TabContent, TabPane } from "reactstrap";

const SliderProduct2 = ({
  setActive,
  active,
  values,
  productData,
  setSearch,
  setFieldValue,
  categoryData,
}) => {
  const [activeTab, setActiveTab] = useState("1");
  const { t } = useTranslation("common");

  return (
    <>
      <div className="shipping-accordion-custom">
        <div
          className="p-3 rule-dropdown d-flex justify-content-between"
          onClick={() => setActive(4)}
        >
          {values["content"]?.["slider_products"]?.["product_slider_3"]?.[
            "title"
          ] || "Text Here"}
          <RiArrowDownLine />
        </div>
        {active == 4 && (
          <>
            <div className="rule-edit-form">
              <SimpleInputField
                nameList={[
                  {
                    name: "[content][categories_products][right_panel][products_list][title]",
                    placeholder: t("enter_title"),
                    title: "title",
                  },
                ]}
              />
              <SearchableSelectInput
                nameList={[
                  {
                    name: "categoryRightContentProduts",
                    title: "products",
                    inputprops: {
                      name: "categoryRightContentProduts",
                      id: "categoryRightContentProduts",
                      options: productData || [],
                      setsearch: setSearch,
                    },
                  },
                ]}
              />
              <CheckBoxField
                name="[content][categories_products][right_panel][products_list][status]"
                title="status"
              />
            </div>
          </>
        )}
      </div>
      <div className="shipping-accordion-custom">
        <div
          className="p-3 rule-dropdown d-flex justify-content-between"
          onClick={() => setActive(5)}
        >
          {values["content"]?.["slider_products"]?.["product_slider_4"]?.[
            "title"
          ] || "Text Here"}
          <RiArrowDownLine />
        </div>
        {active == 5 && (
          <div className="inside-horizontal-tabs">
            <TabTitle
              activeTab={activeTab}
              setActiveTab={setActiveTab}
              titleList={MarketplaceCategoryProductOfferBannerTitle}
            />
            <TabContent activeTab={activeTab}>
              <TabPane tabId="1">
                <FileUploadField
                  paramsProps={{ mime_type: mediaConfig.image.join(",") }}
                  name="categoryProductOfferBanner1Image"
                  title="image"
                  id="categoryProductOfferBanner1Image"
                  showImage={values["categoryProductOfferBanner1Image"]}
                  type="file"
                  values={values}
                  setFieldValue={setFieldValue}
                  helpertext={getHelperText("806x670px")}
                />
                <CommonRedirect
                  values={values}
                  setFieldValue={setFieldValue}
                  productData={productData}
                  categoryData={categoryData}
                  nameList={{
                    selectNameKey: "categoryProductOfferBanner1LinkType",
                    multipleNameKey: "categoryProductOfferBanner1Link",
                  }}
                  setSearch={setSearch}
                />
                <CheckBoxField
                  name={`[content][categories_products][right_panel][offer_banner][banner_1][status]`}
                  title="status"
                />
              </TabPane>
              <TabPane tabId="2">
                <FileUploadField
                  paramsProps={{ mime_type: mediaConfig.image.join(",") }}
                  name="categoryProductOfferBanner2Image"
                  title="image"
                  id="categoryProductOfferBanner2Image"
                  showImage={values["categoryProductOfferBanner2Image"]}
                  type="file"
                  values={values}
                  setFieldValue={setFieldValue}
                  helpertext={getHelperText("806x670px")}
                />
                <CommonRedirect
                  values={values}
                  setFieldValue={setFieldValue}
                  productData={productData}
                  categoryData={categoryData}
                  nameList={{
                    selectNameKey: "categoryProductOfferBanner2LinkType",
                    multipleNameKey: "categoryProductOfferBanner2Link",
                  }}
                  setSearch={setSearch}
                />
                <CheckBoxField
                  name={`[content][categories_products][right_panel][offer_banner][banner_2][status]`}
                  title="status"
                />
              </TabPane>
            </TabContent>
          </div>
        )}
      </div>
      <div className="shipping-accordion-custom">
        <div
          className="p-3 rule-dropdown d-flex justify-content-between"
          onClick={() => setActive(6)}
        >
          {values["content"]?.["slider_products"]?.["product_slider_3"]?.[
            "title"
          ] || "Text Here"}
          <RiArrowDownLine />
        </div>
        {active == 6 && (
          <>
            <div className="rule-edit-form">
              <SimpleInputField
                nameList={[
                  {
                    name: "[content][categories_products][right_panel][category_product][title]",
                    placeholder: t("enter_title"),
                    title: "title",
                  },
                ]}
              />
              <MultiSelectField
                values={values}
                setFieldValue={setFieldValue}
                name={"categoryRightContentCategories"}
                title="categories"
                data={categoryData}
              />
              <CheckBoxField
                name="[content][categories_products][right_panel][category_product][status]"
                title="status"
              />
            </div>
          </>
        )}
      </div>
    </>
  );
};

export default SliderProduct2;
