import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import SearchableSelectInput from "@/components/inputFields/SearchableSelectInput";
import SimpleInputField from "@/components/inputFields/SimpleInputField";
import TabTitle from "@/components/widgets/TabTitle";
import { MarketplaceOneProductList2Title } from "@/data/TabTitleList";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import { useState } from "react";
import { useTranslation } from "react-i18next";
import { TabContent, TabPane } from "reactstrap";
import CommonRedirect from "../../CommonRedirect";
import { mediaConfig } from "@/data/MediaConfig";

const ProductList2Tab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  const { t } = useTranslation("common");
  const [activeTab, setActiveTab] = useState("1");
  return (
    <div className="inside-horizontal-tabs">
      <CheckBoxField
        name={`[content][category_product][status]`}
        title="status"
      />
      <TabTitle
        activeTab={activeTab}
        setActiveTab={setActiveTab}
        titleList={MarketplaceOneProductList2Title}
      />
      <TabContent activeTab={activeTab}>
        <TabPane tabId="1">
          <SimpleInputField
            nameList={[
              {
                name: `[content][category_product][left_panel][title]`,
                placeholder: t("enter_title"),
                title: "title",
              },
            ]}
          />
          <SearchableSelectInput
            nameList={[
              {
                name: "leftPanelProduct",
                title: "products",
                inputprops: {
                  name: "leftPanelProduct",
                  id: "leftPanelProduct",
                  options: productData || [],
                  setsearch: setSearch,
                },
              },
            ]}
          />
          <CheckBoxField
            name={`[content][category_product][left_panel][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="2">
          <h4 className="fw-semibold mb-3 txt-primary w-100">Product </h4>
          <SimpleInputField
            nameList={[
              {
                name: `[content][category_product][right_panel][product_category][title]`,
                placeholder: t("enter_title"),
                title: "tags",
              },
            ]}
          />
          <SearchableSelectInput
            nameList={[
              {
                name: "rightPanelProduct",
                title: "categories",
                inputprops: {
                  name: "rightPanelProduct",
                  id: "rightPanelProduct",
                  options: categoryData || [],
                  setsearch: setSearch,
                },
              },
            ]}
          />
          <CheckBoxField
            name={`[content][category_product][right_panel][product_category][status]`}
            title="status"
          />
          <h4 className="fw-semibold mb-3 txt-primary w-100">Banner</h4>
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="productList2Image"
            title="image"
            id="productList2Image"
            showImage={values["productList2Image"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "rightPanelLinkType",
              multipleNameKey: "rightPanelLink",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][category_product][right_panel][product_banner][status]`}
            title="status"
          />
        </TabPane>
      </TabContent>
    </div>
  );
};

export default ProductList2Tab;
