import { useTranslation } from "react-i18next";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import CommonRedirect from "../../CommonRedirect";
import { mediaConfig } from "@/data/MediaConfig";

const FeaturedBannerTab = ({
  values,
  setFieldValue,
  categoryData,
  productData,
  setSearch,
}) => {
  const { t } = useTranslation("common");
  return (
    <>
      <FileUploadField
        paramsProps={{ mime_type: mediaConfig.image.join(",") }}
        name="offerBanner2Image"
        title="image"
        id="offerBanner2Image"
        showImage={values["offerBanner2Image"]}
        type="file"
        values={values}
        setFieldValue={setFieldValue}
        helpertext={getHelperText("806x670px")}
      />
      <CommonRedirect
        values={values}
        setFieldValue={setFieldValue}
        productData={productData}
        categoryData={categoryData}
        nameList={{
          selectNameKey: "offerBanner2LinkType",
          multipleNameKey: "offerBanner2Link",
        }}
        setSearch={setSearch}
      />
      <CheckBoxField name="[content][offer_banner_2][status]" title="status" />
    </>
  );
};

export default FeaturedBannerTab;
