import { useQuery } from "@tanstack/react-query";
import { forwardRef, useEffect, useImperativeHandle, useState } from "react";
import { Col, TabContent, TabPane } from "reactstrap";
import placeHolderImage from "../../../../public/assets/images/placeholder.png";
import request from "@/utils/axiosUtils";
import { product } from "@/utils/axiosUtils/API";
import Loader from "@/components/commonComponent/Loader";
import BrandTab from "./marketplaceOneTabs/BrandTab";
import HomeBannerTab from "./marketplaceOneTabs/HomeBannerTab";
import OfferBanner1Tab from "./marketplaceOneTabs/OfferBanner1Tab";
import FeaturedBannerTab from "./marketplaceOneTabs/OfferBanner2Tab";
import ProductList1Tab from "./marketplaceOneTabs/ProductList1Tab";
import ProductList2Tab from "./marketplaceOneTabs/ProductList2Tab";
import ServicesTab from "./marketplaceOneTabs/ServicesTab";
import SocialMediaTab from "./marketplaceOneTabs/SocialMediaTab";

const AllTabsMarketplaceOne = forwardRef(
  ({ activeTab, values, setFieldValue, apiData = {} }, ref) => {
    const {
      categoryData,
      blogData,
      brandData,
      categoryLoader,
      brandLoader,
      categoryRefetch,
    } = apiData;
    const [search, setSearch] = useState(false);
    const [customSearch, setCustomSearch] = useState("");
    const [tc, setTc] = useState(null);

    const {
      data: productData,
      isLoading: productLoader,
      refetch,
    } = useQuery(
      { queryKey: [product],
        queryFn: () =>
          request({
            url: product,
            params: {
              status: 1,
              search: customSearch ? customSearch : "",
              paginate:
                values["content"]?.["products_ids"]?.length > 15
                  ? values["content"]?.["products_ids"]?.length
                  : 15,
              ids: customSearch
                ? null
                : values["content"]["products_ids"].join() || null,
              with_union_products: values["content"]?.["products_ids"]?.length
                ? values["content"]?.["products_ids"]?.length >= 15
                  ? 0
                  : 1
                : 0,
            },
          }),
        refetchOnWindowFocus: false,
        select: (res) =>
          res?.data?.data.map((elem) => {
            return {
              id: elem.id,
              name: elem.name,
              image: elem?.product_thumbnail?.original_url || placeHolderImage,
              slug: elem?.slug,
            };
          }),
      }
    );

    useImperativeHandle(ref, () => ({
      call() {
        refetch();
      },
    }));

    // Added debouncing
    useEffect(() => {
      if (tc) clearTimeout(tc);
      setTc(setTimeout(() => setCustomSearch(search), 500));
    }, [search]);
    // Getting users data on searching users
    useEffect(() => {
      refetch();
    }, [customSearch]);

    if (productLoader || categoryLoader) return <Loader />;

    return (
      <Col xl="7" lg="8">
        <TabContent activeTab={activeTab}>
          <TabPane tabId="1">
            <HomeBannerTab
              values={values}
              setFieldValue={setFieldValue}
              categoryData={categoryData}
              productData={productData}
              setSearch={setSearch}
            />
          </TabPane>
          <TabPane tabId="2">
            <OfferBanner1Tab
              values={values}
              setSearch={setSearch}
              setFieldValue={setFieldValue}
              categoryData={categoryData}
              productData={productData}
            />
          </TabPane>
          <TabPane tabId="3">
            <ProductList1Tab
              values={values}
              setFieldValue={setFieldValue}
              productData={productData}
              setSearch={setSearch}
            />
          </TabPane>
          <TabPane tabId="4">
            <FeaturedBannerTab
              values={values}
              setSearch={setSearch}
              setFieldValue={setFieldValue}
              categoryData={categoryData}
              productData={productData}
            />
          </TabPane>
          <TabPane tabId="5">
            <ProductList2Tab
              values={values}
              setSearch={setSearch}
              setFieldValue={setFieldValue}
              categoryData={categoryData}
              productData={productData}
            />
          </TabPane>
          <TabPane tabId="6">
            <ServicesTab
              values={values}
              setSearch={setSearch}
              setFieldValue={setFieldValue}
              categoryData={categoryData}
              productData={productData}
            />
          </TabPane>
          <TabPane tabId="7">
            <SocialMediaTab
              values={values}
              setSearch={setSearch}
              setFieldValue={setFieldValue}
              categoryData={categoryData}
              productData={productData}
            />
          </TabPane>
          <TabPane tabId="8">
            <BrandTab
              values={values}
              setSearch={setSearch}
              setFieldValue={setFieldValue}
              brandData={brandData}
              brandLoader={brandLoader}
            />
          </TabPane>
        </TabContent>
      </Col>
    );
  }
);
export default AllTabsMarketplaceOne;
