import { useState } from "react";
import { useTranslation } from "react-i18next";
import { TabContent, TabPane } from "reactstrap";
import { MarketplaceFourProductAndBannerTitle } from "@/data/TabTitleList";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import SearchableSelectInput from "@/components/inputFields/SearchableSelectInput";
import SimpleInputField from "@/components/inputFields/SimpleInputField";
import TabTitle from "@/components/widgets/TabTitle";
import CommonRedirect from "../../CommonRedirect";
import { mediaConfig } from "@/data/MediaConfig";

const ProductBanner2Tab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  const { t } = useTranslation("common");
  const [activeTab, setActiveTab] = useState("1");
  return (
    <div className="inside-horizontal-tabs">
      <CheckBoxField
        name={`[content][product_banner_2][][status]`}
        title="status"
      />
      <TabTitle
        activeTab={activeTab}
        setActiveTab={setActiveTab}
        titleList={MarketplaceFourProductAndBannerTitle}
      />
      <TabContent activeTab={activeTab}>
        <TabPane tabId="1">
          <SimpleInputField
            nameList={[
              {
                name: `[content][product_banner_2][right_panel][title]`,
                placeholder: t("enter_title"),
                title: "title",
              },
            ]}
          />
          <SearchableSelectInput
            nameList={[
              {
                name: "productBanner2LeftPanelProduct",
                title: "products",
                inputprops: {
                  name: "productBanner2LeftPanelProduct",
                  id: "productBanner2LeftPanelProduct",
                  options: productData || [],
                  setsearch: setSearch,
                },
              },
            ]}
          />
          <CheckBoxField
            name={`[content][product_banner_2][left_panel][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="2">
          <h4 className="fw-semibold mb-3 txt-primary w-100">Banner 1</h4>
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="productBanner2Image1"
            title="image"
            id="productBanner2Image1"
            showImage={values["productBanner2Image1"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "productBanner2LinkType1",
              multipleNameKey: "productBanner2Link1",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name="[content][product_banner_2][center_panel][banner_1][status]"
            title="status"
          />
          <h4 className="fw-semibold mb-3 txt-primary w-100">Banner 2</h4>
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="productBanner2Image2"
            title="image"
            id="productBanner2Image2"
            showImage={values["productBanner2Image2"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "productBanner2LinkType2",
              multipleNameKey: "productBanner2Link2",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name="[content][product_banner_2][center_panel][banner_2][status]"
            title="status"
          />
        </TabPane>
        <TabPane tabId="3">
          <SimpleInputField
            nameList={[
              {
                name: `[content][product_banner_2][right_panel][title]`,
                placeholder: t("enter_title"),
                title: "title",
              },
            ]}
          />
          <SearchableSelectInput
            nameList={[
              {
                name: "productBanner2RightPanelProduct",
                title: "products",
                inputprops: {
                  name: "productBanner2RightPanelProduct",
                  id: "productBanner2RightPanelProduct",
                  options: productData || [],
                  setsearch: setSearch,
                },
              },
            ]}
          />
          <CheckBoxField
            name={`[content][product_banner_2][right_panel][status]`}
            title="status"
          />
        </TabPane>
      </TabContent>
    </div>
  );
};

export default ProductBanner2Tab;
