import { MarketplaceFourProductBanner1Title } from "@/data/TabTitleList";
import { useState } from "react";
import { TabContent, TabPane } from "reactstrap";
import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import SearchableSelectInput from "@/components/inputFields/SearchableSelectInput";
import TabTitle from "@/components/widgets/TabTitle";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import { useTranslation } from "react-i18next";
import CommonRedirect from "../../CommonRedirect";
import { mediaConfig } from "@/data/MediaConfig";

const ProductBanner1Tab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  const { t } = useTranslation("common");
  const [activeTab, setActiveTab] = useState("1");
  return (
    <div className="inside-horizontal-tabs">
      <CheckBoxField
        name={`[content][product_banner_1][status]`}
        title="status"
      />
      <TabTitle
        activeTab={activeTab}
        setActiveTab={setActiveTab}
        titleList={MarketplaceFourProductBanner1Title}
      />
      <TabContent activeTab={activeTab}>
        <TabPane tabId="1">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="productBanner1LeftContentImage"
            title="image"
            id="productBanner1LeftContentImage"
            showImage={values["productBanner1LeftContentImage"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "productBanner1LeftContentLinkType",
              multipleNameKey: "productBanner1LeftContentLink",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][product_banner_1][left_panel][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="2">
          <SearchableSelectInput
            nameList={[
              {
                name: "productBanner1rightPanelProduct",
                title: "products",
                inputprops: {
                  name: "productBanner1rightPanelProduct",
                  id: "productBanner1rightPanelProduct",
                  options: productData || [],
                  setsearch: setSearch,
                },
              },
            ]}
          />
          <CheckBoxField
            name={`[content][product_banner_1][right_panel][status]`}
            title="status"
          />
        </TabPane>
      </TabContent>
    </div>
  );
};

export default ProductBanner1Tab;
