import SimpleInputField from "@/components/inputFields/SimpleInputField";
import { useState } from "react";
import { useTranslation } from "react-i18next";
import { TabContent, TabPane } from "reactstrap";
import { MarijuanaOfferBannerTitle } from "@/data/TabTitleList";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import FileUploadField from "@/components/inputFields/FileUploadField";
import TabTitle from "@/components/widgets/TabTitle";
import CommonRedirect from "../../CommonRedirect";
import CheckBoxField from "@/components/inputFields/CheckBoxField";
import { mediaConfig } from "@/data/MediaConfig";

const OfferBannerTab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  const { t } = useTranslation("common");
  const [activeTab, setActiveTab] = useState("1");
  return (
    <div className="inside-horizontal-tabs">
      <CheckBoxField name={`[content][offer_banner][status]`} title="status" />
      <SimpleInputField
        nameList={[
          {
            name: `[content][offer_banner][tag]`,
            placeholder: t("enter_tag"),
            title: "tags",
          },
          {
            name: `[content][offer_banner][title]`,
            placeholder: t("enter_title"),
            title: "title",
          },
          {
            name: `[content][offer_banner][description]`,
            placeholder: t("enter_description"),
            title: "description",
            type: "textarea",
          },
        ]}
      />
      <TabTitle
        activeTab={activeTab}
        setActiveTab={setActiveTab}
        titleList={MarijuanaOfferBannerTitle}
      />
      <TabContent activeTab={activeTab}>
        <TabPane tabId="1">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="offerBanner1Image"
            title="image"
            id="offerBanner1Image"
            showImage={values["offerBanner1Image"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "offerBanner1LinkType",
              multipleNameKey: "offerBanner1Link",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][offer_banner][banner][banner_1][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="2">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="offerBanner2Image"
            title="image"
            id="offerBanner2Image"
            showImage={values["offerBanner2Image"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "offerBanner2LinkType",
              multipleNameKey: "offerBanner2Link",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][offer_banner][banner][banner_2][status]`}
            title="status"
          />
        </TabPane>
      </TabContent>
    </div>
  );
};

export default OfferBannerTab;
