import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import { mediaConfig } from "@/data/MediaConfig";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import CommonRedirect from "../../CommonRedirect";

const OfferBanner2Tab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  return (
    <>
      <FileUploadField
        paramsProps={{ mime_type: mediaConfig.image.join(",") }}
        name="offerBanner2Image"
        title="image"
        id="offerBanner2Image"
        showImage={values["offerBanner2Image"]}
        type="file"
        values={values}
        setFieldValue={setFieldValue}
        helpertext={getHelperText("375x586px")}
      />
      <CommonRedirect
        values={values}
        setFieldValue={setFieldValue}
        productData={productData}
        categoryData={categoryData}
        nameList={{
          selectNameKey: "offerBanner2LinkType",
          multipleNameKey: "offerBanner2Link",
        }}
        setSearch={setSearch}
      />
      <CheckBoxField
        name={`[content][offer_banner_2][status]`}
        title="status"
      />
    </>
  );
};

export default OfferBanner2Tab;
