import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import Btn from "@/elements/buttons/Btn";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import { useState } from "react";
import { useTranslation } from "react-i18next";
import { RiArrowDownLine, RiCloseLine } from "react-icons/ri";
import { Col, Row } from "reactstrap";
import CommonRedirect from "../../CommonRedirect";
import { mediaConfig } from "@/data/MediaConfig";

const HomeBannerTab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  const { t } = useTranslation("common");
  const [active, setActive] = useState();
  const removeBanners = (index) => {
    if (values["content"]["home_banner"]["banners"].length > 1) {
      let filterValue = values["content"]["home_banner"]["banners"].filter(
        (item, i) => i !== index
      );
      setFieldValue("[content][home_banner][banners]", filterValue);
      filterValue?.forEach((elem, i) => {
        elem?.image_url &&
          setFieldValue(`homeBannerImage${i}`, {
            original_url: elem?.image_url,
          });
        elem?.redirect_link?.link_type &&
          setFieldValue(
            `homeRedirectLinkType${i}`,
            elem?.redirect_link?.link_type
          );
        elem?.redirect_link?.link &&
          setFieldValue(`homeRedirectLink${i}`, elem?.redirect_link?.link);
      });
    }
  };
  return (
    <>
      {
        <Btn
          className="btn-theme my-4"
          onClick={() =>
            setFieldValue("[content][home_banner][banners]", [
              ...values["content"]?.["home_banner"]["banners"],
              { title: "", description: "" },
            ])
          }
          title="add_banners"
        />
      }
      {values["content"]?.["home_banner"]?.["banners"]?.map((elem, index) => {
        return (
          <Row className="align-items-center" key={index}>
            <Col xs="11">
              <div className="shipping-accordion-custom">
                <div
                  className="p-3 rule-dropdown d-flex justify-content-between"
                  onClick={() => setActive((prev) => prev !== index && index)}
                >
                  {t("banner") + " " + (index + 1)}
                  <RiArrowDownLine />
                </div>
                {active == index && (
                  <div className="rule-edit-form">
                    <FileUploadField
                      paramsProps={{ mime_type: mediaConfig.image.join(",") }}
                      name={`homeBannerImage${index}`}
                      title="image"
                      id={`homeBannerImage${index}`}
                      type="file"
                      values={values}
                      setFieldValue={setFieldValue}
                      showImage={values[`homeBannerImage${index}`]}
                      helpertext={getHelperText("376x231px")}
                    />
                    <CommonRedirect
                      values={values}
                      setFieldValue={setFieldValue}
                      productData={productData}
                      categoryData={categoryData}
                      nameList={{
                        selectNameKey: `homeRedirectLinkType${index}`,
                        multipleNameKey: `homeRedirectLink${index}`,
                      }}
                      setSearch={setSearch}
                    />
                    <CheckBoxField
                      name={`[content][home_banner][banners][${index}][status]`}
                      title="status"
                    />
                  </div>
                )}
              </div>
            </Col>
            <Col xs="1">
              <a
                className="h-100 w-100 cursor-pointer close-icon"
                onClick={() => removeBanners(index)}
              >
                <RiCloseLine />
              </a>
            </Col>
          </Row>
        );
      })}
    </>
  );
};

export default HomeBannerTab;
