import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import TabTitle from "@/components/widgets/TabTitle";
import { mediaConfig } from "@/data/MediaConfig";
import { FurnitureTwoFeatureBannerTitle } from "@/data/TabTitleList";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import { useState } from "react";
import { TabContent, TabPane } from "reactstrap";
import CommonRedirect from "../../CommonRedirect";

const OfferBannerTab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  const [activeTab, setActiveTab] = useState("1");
  return (
    <div className="inside-horizontal-tabs">
      <TabTitle
        activeTab={activeTab}
        setActiveTab={setActiveTab}
        titleList={FurnitureTwoFeatureBannerTitle}
      />
      <TabContent activeTab={activeTab}>
        <TabPane tabId="1">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="offerBanner1Image"
            title="image"
            id="offerBanner1"
            showImage={values["offerBanner1"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "offerBanner1LinkType",
              multipleNameKey: "offerBanner1Link",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][offer_banner][banner_1][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="2">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="offerBanner2Image"
            title="image"
            id="offerBanner2Image"
            showImage={values["offerBanner2Image"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "offerBanner2LinkType",
              multipleNameKey: "offerBanner2Link",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][offer_banner][banner_2][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="3">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="offerBanner3Image"
            title="image"
            id="offerBanner3Image"
            showImage={values["offerBanner3Image"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "offerBanner3LinkType",
              multipleNameKey: "offerBanner3Link",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][offer_banner][banner_3][status]`}
            title="status"
          />
        </TabPane>
      </TabContent>
    </div>
  );
};

export default OfferBannerTab;
