import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import SimpleInputField from "@/components/inputFields/SimpleInputField";
import { mediaConfig } from "@/data/MediaConfig";
import Btn from "@/elements/buttons/Btn";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import { useState } from "react";
import { useTranslation } from "react-i18next";
import { RiArrowDownLine, RiCloseLine } from "react-icons/ri";
import { Col, Row } from "reactstrap";
import CommonRedirect from "../../CommonRedirect";

const GridBannerTab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  const { t } = useTranslation("common");
  const [active, setActive] = useState();
  const removeBanners = (index) => {
    if (values["content"]["grid_banner"]["banners"].length > 1) {
      let filterValue = values["content"]["grid_banner"]["banners"].filter(
        (item, i) => i !== index
      );
      setFieldValue("[content][grid_banner][banners]", filterValue);
      filterValue?.forEach((elem, i) => {
        elem?.image_url &&
          setFieldValue(`gridBannerImage${i}`, {
            original_url: elem?.image_url,
          });
        elem?.redirect_link?.link_type &&
          setFieldValue(
            `gridBannerRedirectLinkType${i}`,
            elem?.redirect_link?.link_type
          );
        elem?.redirect_link?.link &&
          setFieldValue(
            `gridBannerRedirectLink${i}`,
            elem?.redirect_link?.link
          );
      });
    }
  };
  return (
    <>
      {
        <Btn
          className="btn-theme my-4"
          onClick={() =>
            setFieldValue("[content][grid_banner][banners]", [
              ...values["content"]?.["grid_banner"]["banners"],
              { title: "", description: "" },
            ])
          }
          title="add_banners"
        />
      }
      {values["content"]?.["grid_banner"]?.["banners"]?.map((elem, index) => {
        return (
          <Row className="align-items-center" key={index}>
            {index % 2 == 0 ? (
              <Col xs="11">
                <div className="shipping-accordion-custom">
                  <div
                    className="p-3 rule-dropdown d-flex justify-content-between"
                    onClick={() => setActive((prev) => prev !== index && index)}
                  >
                    {t("banner") + " " + (index + 1)}
                    <RiArrowDownLine />
                  </div>
                  {active == index && (
                    <div className="rule-edit-form">
                      <FileUploadField
                        paramsProps={{
                          mime_type:
                            index == 0
                              ? mediaConfig.video.join(",")
                              : mediaConfig.image.join(","),
                        }}
                        name={`gridBannerImage${index}`}
                        title={index == 0 ? "Video" : "image"}
                        id={`gridBannerImage${index}`}
                        type="file"
                        values={values}
                        setFieldValue={setFieldValue}
                        showImage={values[`gridBannerImage${index}`]}
                        helpertext={
                          index == 0
                            ? "*Upload video size 10mb recommended"
                            : getHelperText("376x231px")
                        }
                      />
                      {index != 0 && (
                        <CommonRedirect
                          values={values}
                          setFieldValue={setFieldValue}
                          productData={productData}
                          categoryData={categoryData}
                          nameList={{
                            selectNameKey: `gridBannerRedirectLinkType${index}`,
                            multipleNameKey: `gridBannerRedirectLink${index}`,
                          }}
                          setSearch={setSearch}
                        />
                      )}
                      <CheckBoxField
                        name={`[content][grid_banner][banners][${index}][status]`}
                        title="status"
                      />
                    </div>
                  )}
                </div>
              </Col>
            ) : (
              <Col xs="11">
                <div className="shipping-accordion-custom">
                  <div
                    className="p-3 rule-dropdown d-flex justify-content-between"
                    onClick={() => setActive((prev) => prev !== index && index)}
                  >
                    {t("banner") + " " + (index + 1)}
                    <RiArrowDownLine />
                  </div>
                  {active == index && (
                    <div className="rule-edit-form">
                      <SimpleInputField
                        nameList={[
                          {
                            name: `[content][grid_banner][banners][${index}][tag]`,
                            placeholder: t("enter_title"),
                            title: "title",
                          },
                          {
                            name: `[content][grid_banner][banners][${index}][title]`,
                            placeholder: t("enter_title"),
                            title: "title",
                          },
                          {
                            name: `[content][grid_banner][banners][${index}][button_text]`,
                            placeholder: t("enter_title"),
                            title: "title",
                          },
                        ]}
                      />
                      <CommonRedirect
                        values={values}
                        setFieldValue={setFieldValue}
                        productData={productData}
                        categoryData={categoryData}
                        nameList={{
                          selectNameKey: `gridBannerRedirectLinkType${index}`,
                          multipleNameKey: `gridBannerRedirectLink${index}`,
                        }}
                        setSearch={setSearch}
                      />
                      <CheckBoxField
                        name={`[content][grid_banner][banners][${index}][status]`}
                        title="status"
                      />
                    </div>
                  )}
                </div>
              </Col>
            )}
            <Col xs="1">
              <a
                className="h-100 w-100 cursor-pointer close-icon"
                onClick={() => removeBanners(index)}
              >
                <RiCloseLine />
              </a>
            </Col>
          </Row>
        );
      })}
    </>
  );
};

export default GridBannerTab;
