import { getHelperText } from "@/utils/customFunctions/getHelperText";
import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import CommonRedirect from "../../CommonRedirect";
import { mediaConfig } from "@/data/MediaConfig";

const FullBannerTab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  return (
    <>
      <FileUploadField
        paramsProps={{ mime_type: mediaConfig.image.join(",") }}
        name="fullBannerImage"
        title="image"
        id="fullBannerImage"
        showImage={values["fullBannerImage"]}
        type="file"
        values={values}
        setFieldValue={setFieldValue}
        helpertext={getHelperText("1920x1018px")}
      />
      <CommonRedirect
        values={values}
        setFieldValue={setFieldValue}
        productData={productData}
        categoryData={categoryData}
        nameList={{
          selectNameKey: "fullBannerLinkType",
          multipleNameKey: "fullBannerLink",
        }}
        setSearch={setSearch}
      />
      <CheckBoxField name={`[content][full_banner][status]`} title="status" />
    </>
  );
};

export default FullBannerTab;
