import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import TabTitle from "@/components/widgets/TabTitle";
import { mediaConfig } from "@/data/MediaConfig";
import { FurnitureTwoFeatureBannerTitle } from "@/data/TabTitleList";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import { useState } from "react";
import { useTranslation } from "react-i18next";
import { TabContent, TabPane } from "reactstrap";
import CommonRedirect from "../../CommonRedirect";

const FeaturedBannerTab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  const [activeTab, setActiveTab] = useState("1");
  const { t } = useTranslation("common");

  return (
    <div className="inside-horizontal-tabs">
      <TabTitle
        activeTab={activeTab}
        setActiveTab={setActiveTab}
        titleList={FurnitureTwoFeatureBannerTitle}
      />
      <TabContent activeTab={activeTab}>
        <TabPane tabId="1">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="featuredBanner1Image"
            title="image"
            id="featuredBanner1"
            showImage={values["featuredBanner1"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "featuredBanner1LinkType",
              multipleNameKey: "featuredBanner1Link",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][featured_banners][banner_1][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="2">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="featuredBanner2Image"
            title="image"
            id="featuredBanner2Image"
            showImage={values["featuredBanner2Image"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "featuredBanner2LinkType",
              multipleNameKey: "featuredBanner2Link",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][featured_banners][banner_2][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="3">
          <FileUploadField
            paramsProps={{ mime_type: mediaConfig.image.join(",") }}
            name="featuredBanner3Image"
            title="image"
            id="featuredBanner3Image"
            showImage={values["featuredBanner3Image"]}
            type="file"
            values={values}
            setFieldValue={setFieldValue}
            helpertext={getHelperText("806x670px")}
          />
          <CommonRedirect
            values={values}
            setFieldValue={setFieldValue}
            productData={productData}
            categoryData={categoryData}
            nameList={{
              selectNameKey: "featuredBanner3LinkType",
              multipleNameKey: "featuredBanner3Link",
            }}
            setSearch={setSearch}
          />
          <CheckBoxField
            name={`[content][featured_banners][banner_3][status]`}
            title="status"
          />
        </TabPane>
      </TabContent>
    </div>
  );
};

export default FeaturedBannerTab;
