import CheckBoxField from "@/components/inputFields/CheckBoxField";
import MultiSelectField from "@/components/inputFields/MultiSelectField";
import SearchableSelectInput from "@/components/inputFields/SearchableSelectInput";
import TabTitle from "@/components/widgets/TabTitle";
import { ElectronicThreeProductList2Title } from "@/data/TabTitleList";
import { useState } from "react";
import { TabContent, TabPane } from "reactstrap";

const CategoryProducts1Tab = ({
  values,
  setFieldValue,
  productData,
  categoryData,
  setSearch,
}) => {
  const [activeTab, setActiveTab] = useState("1");
  return (
    <div className="inside-horizontal-tabs">
      <CheckBoxField
        name={`[content][category_product_1][status]`}
        title="status"
      />
      <TabTitle
        activeTab={activeTab}
        setActiveTab={setActiveTab}
        titleList={ElectronicThreeProductList2Title}
      />
      <TabContent activeTab={activeTab}>
        <TabPane tabId="1">
          <MultiSelectField
            values={values}
            setFieldValue={setFieldValue}
            name="categoryProduct1Categories"
            title="categories"
            data={categoryData}
          />
          <CheckBoxField
            name={`[content][category_product_1][categories][status]`}
            title="status"
          />
        </TabPane>
        <TabPane tabId="2">
          <SearchableSelectInput
            nameList={[
              {
                name: "categoryProduct1Product",
                title: "products",
                inputprops: {
                  name: "categoryProduct1Product",
                  id: "categoryProduct1Product",
                  options: productData || [],
                  setsearch: setSearch,
                },
              },
            ]}
          />
          <CheckBoxField
            name={`[content][category_product_1][products][status]`}
            title="status"
          />
        </TabPane>
      </TabContent>
    </div>
  );
};

export default CategoryProducts1Tab;
