import CheckBoxField from "@/components/inputFields/CheckBoxField";
import FileUploadField from "@/components/inputFields/FileUploadField";
import SimpleInputField from "@/components/inputFields/SimpleInputField";
import { getHelperText } from "@/utils/customFunctions/getHelperText";
import { useState } from "react";
import { useTranslation } from "react-i18next";
import SliderProduct1 from "./SliderProduct1";
import SliderProduct2 from "./SliderProduct2";
import { mediaConfig } from "@/data/MediaConfig";

const SliderProductTab = ({
  values,
  setFieldValue,
  description,
  productData,
  setSearch,
}) => {
  const [active, setActive] = useState(0);

  const { t } = useTranslation("common");
  return (
    <>
      <h4 className="fw-semibold mb-3 txt-primary w-100">
        {t("product_slider")}{" "}
      </h4>
      <CheckBoxField
        name={`[content][slider_products][status]`}
        title="status"
      />
      <SimpleInputField
        nameList={[
          {
            name: `[content][slider_products][tag]`,
            placeholder: t("enter_tag"),
            title: "tags",
          },
          {
            name: `[content][slider_products][title]`,
            placeholder: t("enter_title"),
            title: "title",
          },
        ]}
      />
      <FileUploadField
        paramsProps={{ mime_type: mediaConfig.image.join(",") }}
        name="sliderProductImage"
        title="image"
        id="sliderProductImage"
        showImage={values["sliderProductImage"]}
        type="file"
        values={values}
        setFieldValue={setFieldValue}
        helpertext={getHelperText("1920x1018px")}
      />
      <SliderProduct1
        active={active}
        setActive={setActive}
        values={values}
        productData={productData}
        setSearch={setSearch}
        setFieldValue={setFieldValue}
      />
      <SliderProduct2
        active={active}
        setActive={setActive}
        values={values}
        description={description}
        productData={productData}
        setSearch={setSearch}
        setFieldValue={setFieldValue}
      />
    </>
  );
};
export default SliderProductTab;
